/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube;

import java.util.List;
import me.laxynd.jinnertube.Thumbnail;
import me.laxynd.jinnertube.VideoPlayer;
import me.laxynd.jinnertube.http.response.CompactVideoRenderer;
import me.laxynd.jinnertube.http.response.Playlist;
import me.laxynd.jinnertube.http.response.PlaylistVideoRenderer;
import me.laxynd.jinnertube.http.response.Text;

public class VideoPreview {
    private final String videoId;
    private final String title;
    private final String author;
    private final String viewText;
    private final String publishedTime;
    private final String duration;
    private final List<Thumbnail> thumbnails;
    private final Thumbnail channelThumbnail;

    public VideoPreview(CompactVideoRenderer compactVideoRenderer) {
        this.videoId = compactVideoRenderer.videoId;
        this.title = Text.toString(compactVideoRenderer.title);
        this.author = Text.toString(compactVideoRenderer.longBylineText);
        this.viewText = Text.toString(compactVideoRenderer.shortViewCountText);
        this.publishedTime = Text.toString(compactVideoRenderer.publishedTimeText);
        this.duration = Text.toString(compactVideoRenderer.lengthText);
        this.channelThumbnail = compactVideoRenderer.channelThumbnail.thumbnails[0];
        this.thumbnails = List.of(compactVideoRenderer.thumbnail.thumbnails);
    }

    public VideoPreview(Playlist.Content.PlaylistPanelVideoRenderer playlistPanelVideoRenderer) {
        this.videoId = playlistPanelVideoRenderer.videoId;
        this.title = Text.toString(playlistPanelVideoRenderer.title);
        this.author = Text.toString(playlistPanelVideoRenderer.longBylineText);
        this.viewText = null;
        this.publishedTime = null;
        this.duration = Text.toString(playlistPanelVideoRenderer.lengthText);
        this.channelThumbnail = null;
        this.thumbnails = List.of(playlistPanelVideoRenderer.thumbnail.thumbnails);
    }

    public VideoPreview(VideoPlayer player) {
        this.videoId = player.getVideoId();
        this.title = player.getTitle();
        this.author = player.getAuthor();
        this.viewText = null;
        this.publishedTime = null;
        this.duration = VideoPreview.toTime(player.getDuration());
        this.channelThumbnail = null;
        this.thumbnails = player.getThumbnails();
    }

    public VideoPreview(PlaylistVideoRenderer playlistVideoRenderer) {
        this.videoId = playlistVideoRenderer.videoId;
        this.title = Text.toString(playlistVideoRenderer.title);
        this.author = Text.toString(playlistVideoRenderer.shortBylineText);
        this.viewText = null;
        this.publishedTime = null;
        this.duration = VideoPreview.toTime(playlistVideoRenderer.lengthSeconds * 1000L);
        this.channelThumbnail = null;
        this.thumbnails = List.of(playlistVideoRenderer.thumbnail.thumbnails);
    }

    private static String toTime(long time) {
        long hours = time / 1000L / 60L / 60L;
        long minutes = time / 1000L / 60L % 60L;
        long seconds = time / 1000L % 60L;
        if (hours >= 1L) {
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }
        return String.format("%02d:%02d", minutes, seconds);
    }

    public String getVideoId() {
        return this.videoId;
    }

    public String getUrl() {
        return "https://youtu.be/" + this.videoId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getViewText() {
        return this.viewText;
    }

    public String getPublishedTime() {
        return this.publishedTime;
    }

    public String getDuration() {
        return this.duration;
    }

    public List<Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public Thumbnail getChannelThumbnail() {
        return this.channelThumbnail;
    }

    public Thumbnail getBestThumbnail() {
        Thumbnail best = this.thumbnails.get(0);
        for (Thumbnail thumbnail : this.thumbnails) {
            if (thumbnail.getWidth() <= best.getWidth()) continue;
            best = thumbnail;
        }
        return best;
    }

    public boolean equals(Object o) {
        if (o instanceof VideoPreview) {
            VideoPreview other = (VideoPreview)o;
            return other.videoId.equalsIgnoreCase(this.videoId);
        }
        return false;
    }
}

