/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.http.endpoint;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import me.laxynd.jinnertube.JInnerTube;
import me.laxynd.jinnertube.SearchResults;
import me.laxynd.jinnertube.VideoPreview;
import me.laxynd.jinnertube.http.Body;
import me.laxynd.jinnertube.http.Context;
import me.laxynd.jinnertube.http.Http;
import me.laxynd.jinnertube.http.Request;
import me.laxynd.jinnertube.http.endpoint.Endpoint;
import me.laxynd.jinnertube.http.response.Contents;
import me.laxynd.jinnertube.http.response.ItemSectionRenderer;
import me.laxynd.jinnertube.http.response.SectionListItem;

public class Search
extends Endpoint {
    public Search(JInnerTube jInnerTube) {
        super(jInnerTube);
    }

    @Override
    public String getEndpoint() {
        return "search";
    }

    public CompletableFuture<SearchResults> search(String query) {
        CompletableFuture<SearchResults> callback = new CompletableFuture<SearchResults>();
        Request request = this.getRequest(new SearchBody(query));
        ((CompletableFuture)Http.downloadAsync(request, SearchResponse.class).thenAccept(result -> {
            SectionListItem[] items;
            ArrayList<VideoPreview> results = new ArrayList<VideoPreview>();
            for (SectionListItem sectionListItem : items = result.contents.sectionListRenderer.contents) {
                if (sectionListItem.itemSectionRenderer == null) continue;
                for (ItemSectionRenderer.Item item : sectionListItem.itemSectionRenderer.contents) {
                    if (item.compactVideoRenderer == null) continue;
                    if (!item.compactVideoRenderer.videoId.equalsIgnoreCase("aQvGIIdgFDM")) {
                        results.add(new VideoPreview(item.compactVideoRenderer));
                        continue;
                    }
                    System.out.println("Video unavailable in search results");
                }
            }
            callback.complete(new SearchResults(query, results));
        })).exceptionally(ex -> {
            callback.completeExceptionally((Throwable)ex);
            return null;
        });
        return callback;
    }

    private static class SearchBody
    implements Body {
        public String query;
        public Context context = new Context();

        public SearchBody(String query) {
            this.query = query;
        }
    }

    private static class SearchResponse {
        public Contents contents;

        private SearchResponse() {
        }
    }
}

