/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube;

import java.util.ArrayList;
import java.util.List;
import me.laxynd.jinnertube.Thumbnail;
import me.laxynd.jinnertube.VideoPreview;
import me.laxynd.jinnertube.format.AudioFormat;
import me.laxynd.jinnertube.format.Format;
import me.laxynd.jinnertube.format.VideoAudioFormat;
import me.laxynd.jinnertube.format.VideoFormat;
import me.laxynd.jinnertube.http.response.PlayerConfig;
import me.laxynd.jinnertube.http.response.StreamingData;
import me.laxynd.jinnertube.http.response.VideoDetails;

public class VideoPlayer {
    private final String videoId;
    private final String title;
    private final String author;
    private final long duration;
    private final List<Format> formats;
    private final List<Thumbnail> thumbnails;
    private final double loudnessDb;
    private final double perceptualLoudnessDb;
    private final long expires;

    public VideoPlayer(VideoDetails details, StreamingData streamingData, PlayerConfig config, List<Format> formats) {
        this.videoId = details.videoId;
        this.title = details.title;
        this.author = details.author;
        this.duration = details.lengthSeconds * 1000L;
        this.formats = formats;
        this.thumbnails = List.of(details.thumbnail.thumbnails);
        this.loudnessDb = config.audioConfig.loudnessDb;
        this.perceptualLoudnessDb = config.audioConfig.perceptualLoudnessDb;
        this.expires = System.currentTimeMillis() + Long.parseLong(streamingData.expiresInSeconds) * 1000L;
    }

    public String getVideoId() {
        return this.videoId;
    }

    public String getUrl() {
        return "https://youtu.be/" + this.videoId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }

    public long getDuration() {
        return this.duration;
    }

    public List<Thumbnail> getThumbnails() {
        return this.thumbnails;
    }

    public Thumbnail getBestThumbnail() {
        Thumbnail best = this.thumbnails.get(0);
        for (Thumbnail thumbnail : this.thumbnails) {
            if (thumbnail.getWidth() <= best.getWidth()) continue;
            best = thumbnail;
        }
        return best;
    }

    public List<Format> getFormats() {
        return this.formats;
    }

    public List<VideoFormat> getVideoFormats() {
        ArrayList<VideoFormat> videoFormats = new ArrayList<VideoFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoFormat)) continue;
            VideoFormat videoFormat = (VideoFormat)format;
            videoFormats.add(videoFormat);
        }
        return videoFormats;
    }

    public List<AudioFormat> getAudioFormats() {
        ArrayList<AudioFormat> audioFormats = new ArrayList<AudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof AudioFormat)) continue;
            AudioFormat audioFormat = (AudioFormat)format;
            audioFormats.add(audioFormat);
        }
        return audioFormats;
    }

    public List<VideoAudioFormat> getVideoAudioFormats() {
        ArrayList<VideoAudioFormat> videoAudioFormats = new ArrayList<VideoAudioFormat>();
        for (Format format : this.formats) {
            if (!(format instanceof VideoAudioFormat)) continue;
            VideoAudioFormat videoAudioFormat = (VideoAudioFormat)format;
            videoAudioFormats.add(videoAudioFormat);
        }
        return videoAudioFormats;
    }

    public VideoFormat getBestVideoFormat() {
        VideoFormat best = null;
        for (VideoFormat format : this.getVideoFormats()) {
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getWidth() <= best.getWidth()) continue;
            best = format;
        }
        return best;
    }

    public VideoAudioFormat getBestVideoAudioFormat() {
        VideoAudioFormat best = null;
        for (VideoAudioFormat format : this.getVideoAudioFormats()) {
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getWidth() <= best.getWidth()) continue;
            best = format;
        }
        return best;
    }

    public AudioFormat getBestAudioFormat() {
        AudioFormat best = null;
        for (AudioFormat format : this.getAudioFormats()) {
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getAudioSampleRate() <= best.getAudioSampleRate()) continue;
            best = format;
        }
        return best;
    }

    public VideoFormat getBestVideoFormat(int maxHeight) {
        VideoFormat best = null;
        for (VideoFormat format : this.getVideoFormats()) {
            if (format.getHeight() > maxHeight) continue;
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getWidth() <= best.getWidth()) continue;
            best = format;
        }
        return best;
    }

    public VideoAudioFormat getBestVideoAudioFormat(int maxHeight) {
        VideoAudioFormat best = null;
        for (VideoAudioFormat format : this.getVideoAudioFormats()) {
            if (format.getHeight() > maxHeight) continue;
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getWidth() <= best.getWidth()) continue;
            best = format;
        }
        return best;
    }

    public AudioFormat getBestAudioFormat(long maxSampleRate) {
        AudioFormat best = null;
        for (AudioFormat format : this.getAudioFormats()) {
            if (format.getAudioSampleRate() > maxSampleRate) continue;
            if (best == null) {
                best = format;
                continue;
            }
            if (format.getAudioSampleRate() <= best.getAudioSampleRate()) continue;
            best = format;
        }
        return best;
    }

    public double getLoudnessDb() {
        return this.loudnessDb;
    }

    public double getPerceptualLoudnessDb() {
        return this.perceptualLoudnessDb;
    }

    public VideoPreview asPreview() {
        return new VideoPreview(this);
    }

    public long getEstimatedExpiration() {
        return this.expires;
    }
}

