/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.http.endpoint;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import me.laxynd.jinnertube.JInnerTube;
import me.laxynd.jinnertube.VideoPlayer;
import me.laxynd.jinnertube.exception.VideoUnavailableException;
import me.laxynd.jinnertube.format.AudioFormat;
import me.laxynd.jinnertube.format.Format;
import me.laxynd.jinnertube.format.VideoAudioFormat;
import me.laxynd.jinnertube.format.VideoFormat;
import me.laxynd.jinnertube.http.Body;
import me.laxynd.jinnertube.http.Context;
import me.laxynd.jinnertube.http.Http;
import me.laxynd.jinnertube.http.Request;
import me.laxynd.jinnertube.http.endpoint.Endpoint;
import me.laxynd.jinnertube.http.response.AdaptiveFormat;
import me.laxynd.jinnertube.http.response.PlayerConfig;
import me.laxynd.jinnertube.http.response.StreamingData;
import me.laxynd.jinnertube.http.response.VideoDetails;

public class Player
extends Endpoint {
    public Player(JInnerTube jInnerTube) {
        super(jInnerTube);
    }

    @Override
    public String getEndpoint() {
        return "player";
    }

    public CompletableFuture<VideoPlayer> player(String videoId) {
        return this.player(videoId, 1);
    }

    public CompletableFuture<VideoPlayer> player(String videoId, int retries) {
        CompletableFuture<VideoPlayer> callback = new CompletableFuture<VideoPlayer>();
        Request request = this.getRequest(new PlayerBody(videoId));
        ((CompletableFuture)Http.downloadAsync(request, PlayerResponse.class).thenAccept(result -> {
            if (!result.videoDetails.videoId.equalsIgnoreCase(videoId)) {
                if (retries > 0) {
                    ((CompletableFuture)this.player(videoId, retries - 1).thenAccept(callback::complete)).exceptionally(e -> {
                        callback.completeExceptionally((Throwable)e);
                        return null;
                    });
                } else {
                    callback.completeExceptionally(new VideoUnavailableException("YouTube gave us the wrong video, please try again later!"));
                }
            } else if (!result.playabilityStatus.status.equalsIgnoreCase("OK")) {
                callback.completeExceptionally(new VideoUnavailableException("Playability status not OK: " + result.playabilityStatus.status));
            } else if (result.streamingData == null) {
                callback.completeExceptionally(new VideoUnavailableException("Missing streaming data"));
            } else {
                ArrayList<Format> formats = new ArrayList<Format>();
                if (result.streamingData.formats != null) {
                    for (me.laxynd.jinnertube.http.response.Format format : result.streamingData.formats) {
                        if (format.mimeType.startsWith("video")) {
                            if (format.audioChannels != 0) {
                                formats.add(new VideoAudioFormat(format));
                                continue;
                            }
                            formats.add(new VideoFormat(format));
                            continue;
                        }
                        formats.add(new AudioFormat(format));
                    }
                }
                if (result.streamingData.adaptiveFormats != null) {
                    for (AdaptiveFormat adaptiveFormat : result.streamingData.adaptiveFormats) {
                        if (adaptiveFormat.mimeType.startsWith("video")) {
                            if (adaptiveFormat.audioChannels != 0) {
                                formats.add(new VideoAudioFormat(adaptiveFormat));
                                continue;
                            }
                            formats.add(new VideoFormat(adaptiveFormat));
                            continue;
                        }
                        formats.add(new AudioFormat(adaptiveFormat));
                    }
                }
                callback.complete(new VideoPlayer(result.videoDetails, result.streamingData, result.playerConfig, formats));
            }
        })).exceptionally(ex -> {
            callback.completeExceptionally((Throwable)ex);
            return null;
        });
        return callback;
    }

    private static class PlayerBody
    implements Body {
        public String videoId;
        public Context context = new Context();

        public PlayerBody(String videoId) {
            this.videoId = videoId;
        }
    }

    private static class PlayerResponse {
        public PlayabilityStatus playabilityStatus;
        public StreamingData streamingData;
        public VideoDetails videoDetails;
        public PlayerConfig playerConfig;

        private PlayerResponse() {
        }

        private static class PlayabilityStatus {
            public String status;

            private PlayabilityStatus() {
            }
        }
    }
}

