/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.http.endpoint;

import java.util.concurrent.CompletableFuture;
import me.laxynd.jinnertube.JInnerTube;
import me.laxynd.jinnertube.Playlist;
import me.laxynd.jinnertube.VideoPreview;
import me.laxynd.jinnertube.http.Body;
import me.laxynd.jinnertube.http.Context;
import me.laxynd.jinnertube.http.Http;
import me.laxynd.jinnertube.http.Request;
import me.laxynd.jinnertube.http.endpoint.Endpoint;
import me.laxynd.jinnertube.http.response.PlaylistVideoListRenderer;
import me.laxynd.jinnertube.http.response.SectionListRenderer;
import me.laxynd.jinnertube.http.response.Text;

public class BrowsePlaylist
extends Endpoint {
    public BrowsePlaylist(JInnerTube jInnerTube) {
        super(jInnerTube);
    }

    @Override
    public String getEndpoint() {
        return "browse";
    }

    public CompletableFuture<Playlist> browse(String playlistId) {
        CompletableFuture<Playlist> callback = new CompletableFuture<Playlist>();
        Request request = this.getRequest(new BrowseBody(playlistId));
        ((CompletableFuture)Http.downloadAsync(request, BrowseResponse.class).thenAccept(result -> {
            Playlist playlist = new Playlist(this, (BrowseResponse)result);
            callback.complete(playlist);
        })).exceptionally(ex -> {
            callback.completeExceptionally((Throwable)ex);
            return null;
        });
        return callback;
    }

    public CompletableFuture<Void> continuation(Playlist playlist) {
        CompletableFuture<Void> callback = new CompletableFuture<Void>();
        Request request = this.getRequest(new ContinueBody(playlist.getContinuation()));
        ((CompletableFuture)Http.downloadAsync(request, ContinueResponse.class).thenAccept(result -> {
            for (PlaylistVideoListRenderer.Item item : result.continuationContents.playlistVideoListContinuation.contents) {
                if (item.playlistVideoRenderer == null) continue;
                playlist.getVideos().add(new VideoPreview(item.playlistVideoRenderer));
            }
            if (result.continuationContents.playlistVideoListContinuation.continuations != null) {
                playlist.setContinuation(result.continuationContents.playlistVideoListContinuation.continuations[0].nextContinuationData.continuation);
            } else {
                playlist.setContinuation(null);
            }
            callback.complete(null);
        })).exceptionally(ex -> {
            callback.completeExceptionally((Throwable)ex);
            return null;
        });
        return callback;
    }

    private static class BrowseBody
    implements Body {
        public String browseId;
        public Context context = new Context();

        private BrowseBody(String playlistId) {
            this.browseId = "VL" + playlistId;
        }
    }

    public static class BrowseResponse {
        public Contents contents;
        public Header header;

        public static class Header {
            public PlaylistHeaderRenderer playlistHeaderRenderer;

            public static class PlaylistHeaderRenderer {
                public String playlistId;
                public Text title;
                public Text numVideosText;
                public Text descriptionText;
                public Text ownerText;
                public Text viewCountText;
            }
        }

        public static class Contents {
            public SingleColumnBrowseResultsRenderer singleColumnBrowseResultsRenderer;

            public static class SingleColumnBrowseResultsRenderer {
                public Tab[] tabs;

                public static class Tab {
                    public TabRenderer tabRenderer;

                    public static class TabRenderer {
                        public Content content;

                        public static class Content {
                            public SectionListRenderer sectionListRenderer;
                        }
                    }
                }
            }
        }
    }

    private static class ContinueBody
    implements Body {
        public String continuation;
        public Context context = new Context();

        public ContinueBody(String continuation) {
            this.continuation = continuation;
        }
    }

    public static class ContinueResponse {
        public ContinuationContents continuationContents;

        public static class ContinuationContents {
            public PlaylistVideoListRenderer playlistVideoListContinuation;
        }
    }
}

