/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.http;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import me.laxynd.jinnertube.http.Request;

public class Http {
    private static final int MAX_RETRIES = 2;
    private static final ExecutorService scheduler = Executors.newCachedThreadPool();

    public static CompletableFuture<String> downloadAsync(Request request) {
        CompletableFuture<String> callback = new CompletableFuture<String>();
        scheduler.execute(() -> {
            try {
                callback.complete(Http.download(request));
            }
            catch (Exception e) {
                callback.completeExceptionally(e);
            }
        });
        return callback;
    }

    public static <T> CompletableFuture<T> downloadAsync(Request request, Class<T> clazz) {
        CompletableFuture callback = new CompletableFuture();
        scheduler.execute(() -> {
            try {
                String result = Http.download(request);
                if (result.isEmpty()) {
                    callback.complete(null);
                } else {
                    callback.complete(new Gson().fromJson(result, clazz));
                }
            }
            catch (Exception e) {
                callback.completeExceptionally(e);
            }
        });
        return callback;
    }

    public static JsonObject downloadSync(Request request) throws IOException {
        String result = Http.download(request);
        if (result.isEmpty()) {
            return null;
        }
        return new JsonParser().parse(result).getAsJsonObject();
    }

    public static <T> T downloadSync(Request request, Class<T> clazz) throws IOException {
        String result = Http.download(request);
        if (result.isEmpty()) {
            return null;
        }
        return (T)new Gson().fromJson(result, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String download(Request request) throws IOException {
        IOException exception;
        String downloadUrl = request.getUrl();
        Map<String, String> headers = request.getHeaders();
        int maxRetries = 2;
        StringBuilder result = new StringBuilder();
        do {
            try {
                String inputLine;
                BufferedReader br;
                HttpURLConnection urlConnection;
                block17: {
                    int responseCode;
                    urlConnection = Http.openConnection(downloadUrl, headers);
                    urlConnection.setRequestMethod(request.getMethod());
                    if (request.getBody() != null) {
                        urlConnection.setDoOutput(true);
                        try (OutputStreamWriter outputWriter = new OutputStreamWriter(urlConnection.getOutputStream(), StandardCharsets.UTF_8);){
                            outputWriter.write(request.getBody());
                            outputWriter.flush();
                        }
                    }
                    if ((responseCode = urlConnection.getResponseCode()) < 300) break block17;
                    br = null;
                    System.out.println(responseCode);
                    try {
                        br = new BufferedReader(new InputStreamReader(urlConnection.getErrorStream(), StandardCharsets.UTF_8));
                        while ((inputLine = br.readLine()) != null) {
                            result.append(inputLine).append("\n");
                        }
                    }
                    catch (Throwable throwable) {
                        Http.closeSilently(br);
                        throw throwable;
                    }
                    Http.closeSilently(br);
                    throw new IOException("Failed to download: " + responseCode);
                }
                br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8));
                    while ((inputLine = br.readLine()) != null) {
                        result.append(inputLine).append("\n");
                    }
                }
                catch (Throwable throwable) {
                    Http.closeSilently(br);
                    throw throwable;
                }
                Http.closeSilently(br);
                exception = null;
            }
            catch (IOException e) {
                --maxRetries;
                exception = e;
            }
        } while (maxRetries > 0 && exception != null);
        if (exception != null) {
            throw exception;
        }
        return result.toString();
    }

    private static HttpURLConnection openConnection(String httpUrl, Map<String, String> headers) throws IOException {
        URL url = new URL(httpUrl);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return urlConnection;
    }

    private static void closeSilently(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

