/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.format;

import me.laxynd.jinnertube.format.AudioFormat;
import me.laxynd.jinnertube.format.Extension;
import me.laxynd.jinnertube.http.response.AdaptiveFormat;

public abstract class Format {
    private final String url;
    private final String mimeType;
    private final long bitrate;
    private final long duration;
    private final boolean isAdaptive;

    public Format(me.laxynd.jinnertube.http.response.Format response) {
        this.url = response.url;
        this.mimeType = response.mimeType;
        this.bitrate = response.bitrate;
        this.duration = response.approxDurationMs;
        this.isAdaptive = false;
    }

    public Format(AdaptiveFormat response) {
        this.url = response.url;
        this.mimeType = response.mimeType;
        this.bitrate = response.bitrate;
        this.duration = response.approxDurationMs;
        this.isAdaptive = true;
    }

    public String getUrl() {
        return this.url;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getBitrate() {
        return this.bitrate;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isAdaptive() {
        return this.isAdaptive;
    }

    public String getExtension() {
        Extension extension = this.mimeType == null || this.mimeType.isEmpty() ? Extension.UNKNOWN : (this.mimeType.contains(Extension.MPEG4.value()) ? (this instanceof AudioFormat ? Extension.M4A : Extension.MPEG4) : (this.mimeType.contains(Extension.WEBM.value()) ? (this instanceof AudioFormat ? Extension.WEBA : Extension.WEBM) : (this.mimeType.contains(Extension.FLV.value()) ? Extension.FLV : (this.mimeType.contains(Extension._3GP.value()) ? Extension._3GP : Extension.UNKNOWN))));
        return extension.value();
    }
}

