/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube.account;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import me.laxynd.jinnertube.account.Account;
import me.laxynd.jinnertube.http.Request;

public class CookieAccount
extends Account {
    private String SID;
    private String HSID;
    private String SSID;
    private String APISID;
    private String SAPISID;
    private final String origin = "https://www.youtube.com";

    public CookieAccount(String SID, String HSID, String SSID, String APISID, String SAPISID) {
        this.SID = SID;
        this.HSID = HSID;
        this.SSID = SSID;
        this.APISID = APISID;
        this.SAPISID = SAPISID;
    }

    @Override
    public void authenticateRequest(Request request) {
        request.header("Authorization", this.getSAPISIDHASH());
        request.header("Cookie", this.getCookieString());
        request.header("x-origin", "https://www.youtube.com");
        request.header("Origin", "https://www.youtube.com");
    }

    public String getSAPISIDHASH() {
        long time = System.currentTimeMillis();
        try {
            String preHash = time + " " + this.SAPISID + " https://www.youtube.com";
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.reset();
            digest.update(preHash.getBytes(StandardCharsets.UTF_8));
            String SAPISIDHASH = String.format("%040x", new BigInteger(1, digest.digest()));
            return "SAPISIDHASH " + time + "_" + SAPISIDHASH;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public String getCookieString() {
        return "SID=" + this.SID + "; HSID=" + this.HSID + "; SSID=" + this.SSID + "; APISID=" + this.APISID + "; SAPISID=" + this.SAPISID + "; ";
    }

    public static class Builder {
        private String SID = "";
        private String HSID = "";
        private String SSID = "";
        private String APISID = "";
        private String SAPISID = "";

        public Builder setSID(String SID) {
            this.SID = SID;
            return this;
        }

        public Builder setHSID(String HSID) {
            this.HSID = HSID;
            return this;
        }

        public Builder setSSID(String SSID) {
            this.SSID = SSID;
            return this;
        }

        public Builder setAPISID(String APISID) {
            this.APISID = APISID;
            return this;
        }

        public Builder setSAPISID(String SAPISID) {
            this.SAPISID = SAPISID;
            return this;
        }

        public CookieAccount build() {
            return new CookieAccount(this.SID, this.HSID, this.SSID, this.APISID, this.SAPISID);
        }
    }
}

