/*
 * Decompiled with CFR 0.152.
 */
package me.laxynd.jinnertube;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.laxynd.jinnertube.VideoPreview;
import me.laxynd.jinnertube.http.endpoint.BrowsePlaylist;
import me.laxynd.jinnertube.http.response.Playlist;
import me.laxynd.jinnertube.http.response.PlaylistVideoListRenderer;
import me.laxynd.jinnertube.http.response.SectionListItem;
import me.laxynd.jinnertube.http.response.Text;

public class Playlist {
    private final BrowsePlaylist endpoint;
    private final String playlistId;
    private final String title;
    private final String url;
    private final int count;
    private final String author;
    private final List<VideoPreview> videos = new ArrayList<VideoPreview>();
    private String continuation;

    public Playlist(BrowsePlaylist endpoint, me.laxynd.jinnertube.http.response.Playlist response) {
        this.endpoint = endpoint;
        this.playlistId = response.playlistId;
        this.title = response.title;
        this.url = "https://youtube.com/playlist?list=" + response.playlistId;
        this.count = response.totalVideos;
        this.author = Text.toString(response.ownerName);
        for (Playlist.Content video : response.contents) {
            if (video.playlistPanelVideoRenderer == null || video.playlistPanelVideoRenderer.title == null) continue;
            this.videos.add(new VideoPreview(video.playlistPanelVideoRenderer));
        }
    }

    public Playlist(BrowsePlaylist endpoint, BrowsePlaylist.BrowseResponse response) {
        this.endpoint = endpoint;
        this.playlistId = response.header.playlistHeaderRenderer.playlistId;
        this.title = Text.toString(response.header.playlistHeaderRenderer.title);
        this.url = "https://youtube.com/playlist?list=" + this.playlistId;
        this.count = response.header.playlistHeaderRenderer.numVideosText.getFirstAsInt();
        this.author = Text.toString(response.header.playlistHeaderRenderer.ownerText);
        for (BrowsePlaylist.BrowseResponse.Contents.SingleColumnBrowseResultsRenderer.Tab tab : response.contents.singleColumnBrowseResultsRenderer.tabs) {
            if (tab.tabRenderer == null) continue;
            for (SectionListItem item : tab.tabRenderer.content.sectionListRenderer.contents) {
                if (item.playlistVideoListRenderer == null) continue;
                if (item.playlistVideoListRenderer.continuations != null) {
                    this.continuation = item.playlistVideoListRenderer.continuations[0].nextContinuationData.continuation;
                }
                for (PlaylistVideoListRenderer.Item video : item.playlistVideoListRenderer.contents) {
                    if (video.playlistVideoRenderer == null) continue;
                    this.videos.add(new VideoPreview(video.playlistVideoRenderer));
                }
            }
        }
    }

    public String getPlaylistId() {
        return this.playlistId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVideoCount() {
        return this.count;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<VideoPreview> getVideos() {
        return this.videos;
    }

    public String getContinuation() {
        return this.continuation;
    }

    public void setContinuation(String continuation) {
        this.continuation = continuation;
    }

    public CompletableFuture<Boolean> next() {
        CompletableFuture<Boolean> callback = new CompletableFuture<Boolean>();
        if (this.continuation == null || this.endpoint == null) {
            callback.complete(false);
        } else {
            ((CompletableFuture)this.endpoint.continuation(this).thenAccept(v -> callback.complete(true))).exceptionally(ex -> {
                callback.completeExceptionally((Throwable)ex);
                return null;
            });
        }
        return callback;
    }

    public CompletableFuture<Void> loadAll() {
        CompletableFuture<Void> callback = new CompletableFuture<Void>();
        ((CompletableFuture)this.next().thenAccept(b -> {
            if (b.booleanValue()) {
                ((CompletableFuture)this.loadAll().thenAccept(v -> callback.complete(null))).exceptionally(ex -> {
                    callback.completeExceptionally((Throwable)ex);
                    return null;
                });
            } else {
                callback.complete(null);
            }
        })).exceptionally(ex -> {
            callback.completeExceptionally((Throwable)ex);
            return null;
        });
        return callback;
    }
}

