/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api.command;

import com.google.common.base.Joiner;
import com.siblaze.disbot.api.DiscordBot;
import com.siblaze.disbot.api.command.Command;
import com.siblaze.disbot.api.command.CommandEvent;
import com.siblaze.disbot.api.command.CommandOption;
import com.siblaze.disbot.api.command.OptionValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class CommandManager
extends ListenerAdapter {
    private final List<Command> commands = new ArrayList<Command>();
    private final DiscordBot bot;
    private final JDA jda;
    private String prefix = "!";

    public CommandManager(DiscordBot bot) {
        this.bot = bot;
        this.jda = bot.getJda();
        this.jda.addEventListener(new Object[]{this});
        this.jda.updateCommands().queue();
    }

    public Command[] getCommands(int contexts) {
        ArrayList<Command> commands = new ArrayList<Command>();
        for (Command cmd : this.commands) {
            if ((cmd.getContext() & contexts) == 0) continue;
            commands.add(cmd);
        }
        return commands.toArray(new Command[0]);
    }

    public void registerCommand(Command command) {
        this.commands.add(command);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public void registerCommand(Command command, int contexts) {
        command.setContext(contexts);
        this.registerCommand(command);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public Command getCommand(String label, boolean dm) {
        return this.getCommand(label);
    }

    public Command getCommand(String label) {
        for (Command cmd : this.commands) {
            if (!cmd.matches(label)) continue;
            return cmd;
        }
        return null;
    }

    public void updateCommands() {
        ArrayList<SlashCommandData> slashCommandData = new ArrayList<SlashCommandData>();
        for (Command command : this.getCommands(12)) {
            SlashCommandData data = Commands.slash((String)command.getName(), (String)command.getDescription());
            data.setDefaultPermissions(command.getDefaultSlashPermission());
            data.addOptions((Collection)command.getOptions().stream().map(CommandOption::getOptionData).collect(Collectors.toList()));
            if ((command.getContext() & 8) == 0) {
                data.setGuildOnly(true);
            }
            slashCommandData.add(data);
        }
        this.jda.updateCommands().addCommands(slashCommandData).queue();
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        try {
            String msg = event.getMessage().getContentRaw();
            if (msg.startsWith(this.prefix)) {
                Command[] commands;
                String command = msg.split(" ")[0].substring(this.prefix.length());
                for (Command cmd : commands = event.isFromGuild() || event.isFromThread() ? this.getCommands(1) : this.getCommands(2)) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.getAbility().hasAbility(this.bot, event.getMember())) {
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        ArrayList<String> anonymousOptions = new ArrayList<String>();
                        ArrayList<String> unrecognizedOptions = new ArrayList<String>();
                        if (msg.contains(" ")) {
                            String[] split = msg.split(" ", 2)[1].split(" ");
                            for (String s : split) {
                                if (s.startsWith("-")) {
                                    String name;
                                    if (s.contains("=")) {
                                        name = s.split("=")[0].substring(1);
                                        String value = s.split("=")[1];
                                        CommandOption option = cmd.getOption(name);
                                        if (option != null) {
                                            if (option.getAbility().hasAbility(this.bot, event.getMember())) {
                                                options.put(option.getName(), new OptionValue(option.getType(), option.getName(), value));
                                                continue;
                                            }
                                            unrecognizedOptions.add(name);
                                            continue;
                                        }
                                        unrecognizedOptions.add(name);
                                        continue;
                                    }
                                    name = s.substring(1);
                                    CommandOption option = cmd.getOption(name);
                                    if (option != null) {
                                        if (option.getAbility().hasAbility(this.bot, event.getMember())) {
                                            options.put(option.getName(), new OptionValue(option.getType(), option.getName(), "true"));
                                            continue;
                                        }
                                        unrecognizedOptions.add(name);
                                        continue;
                                    }
                                    unrecognizedOptions.add(name);
                                    continue;
                                }
                                anonymousOptions.add(s);
                            }
                        }
                        if (cmd.getAnonymousField() != null && anonymousOptions.size() > 0) {
                            String anonymousString = Joiner.on((char)' ').join(anonymousOptions);
                            options.putIfAbsent(cmd.getAnonymousField(), new OptionValue(OptionType.STRING, cmd.getAnonymousField(), anonymousString));
                        } else {
                            int index = 0;
                            for (CommandOption option : cmd.getOptions()) {
                                if (index >= anonymousOptions.size()) break;
                                if (options.containsKey(option.getName()) || !option.getAbility().hasAbility(this.bot, event.getMember())) continue;
                                options.put(option.getName(), new OptionValue(option.getType(), option.getName(), (String)anonymousOptions.get(index++)));
                            }
                        }
                        for (CommandOption option : cmd.getOptions()) {
                            if (options.containsKey(option.getName()) || !option.isRequired()) continue;
                            cmd.missingOption(option, (MessageChannel)event.getChannel());
                            return;
                        }
                        if (unrecognizedOptions.size() > 0) {
                            EmbedBuilder eb = new EmbedBuilder();
                            eb.setTitle("Unknown Options Provided");
                            eb.setColor(Color.RED);
                            for (String option : unrecognizedOptions) {
                                eb.addField("", option, true);
                            }
                            eb.addField("", "Tip: Using slash commands will show you all valid options", false);
                            event.getChannel().sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getAuthor()).setMember(event.getMember()).setChannel(event.getChannel()).setMessage(event.getMessage()).setGuild(event.getGuild());
                        cmd.onCommand(ce, options);
                    } else {
                        event.getChannel().sendMessage((CharSequence)"Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EmbedBuilder eb = new EmbedBuilder();
            eb.setTitle("An error occurred");
            eb.setColor(Color.RED);
            eb.addField("", e.getLocalizedMessage(), true);
            event.getChannel().sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
        }
    }

    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        try {
            String command = event.getName();
            if (event.getGuild() != null) {
                for (Command cmd : this.getCommands(4)) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.getAbility().hasAbility(this.bot, event.getMember())) {
                        List optionMap = event.getOptions();
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        for (OptionMapping map : optionMap) {
                            options.put(map.getName(), new OptionValue(map.getType(), map.getName(), map.getAsString()));
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getUser()).setMember(event.getMember()).setChannel(event.getChannel()).setSlashCommand(true).setSlashCommandEvent(event).setGuild(event.getGuild());
                        cmd.onCommand(ce, options);
                    } else {
                        event.reply("Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
            } else {
                for (Command cmd : this.getCommands(8)) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.getAbility().hasAbility(this.bot, event.getMember())) {
                        List optionMap = event.getOptions();
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        for (OptionMapping map : optionMap) {
                            options.put(map.getName(), new OptionValue(map.getType(), map.getName(), map.getAsString()));
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getUser()).setMember(event.getMember()).setChannel(event.getChannel()).setSlashCommand(true).setSlashCommandEvent(event);
                        cmd.onCommand(ce, options);
                    } else {
                        event.reply("Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
                event.reply("Sorry, this command is only available on servers").queue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EmbedBuilder eb = new EmbedBuilder();
            eb.setTitle("An error occurred");
            eb.setColor(Color.RED);
            eb.addField("", e.getLocalizedMessage(), true);
            event.replyEmbeds(eb.build(), new MessageEmbed[0]).queue();
        }
    }

    public DiscordBot getBot() {
        return this.bot;
    }

    public JDA getJda() {
        return this.jda;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

