/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api;

import com.google.gson.Gson;
import com.siblaze.disbot.api.BotConfiguration;
import com.siblaze.disbot.api.Developer;
import com.siblaze.disbot.api.command.CommandManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscordBot {
    private BotConfiguration config;
    private JDA jda;
    private CommandManager commandManager;
    private Logger logger;

    public void onLogin(JDABuilder jdaBuilder) {
    }

    public void onEnable() {
    }

    public String getName() {
        return this.config.getName().isEmpty() ? this.getClass().getSimpleName() : this.config.getName();
    }

    public String getVersion() {
        return this.config.getVersion();
    }

    public Developer[] getDevelopers() {
        return this.config.getDevelopers();
    }

    public String getDevelopersAsString() {
        return this.getDevelopers().length == 0 ? "Unknown" : Arrays.stream(this.getDevelopers()).map(Developer::getName).reduce((a, b) -> a + ", " + b).orElse("Unknown");
    }

    public void load(State state) {
        if (this.getConfig() == null) {
            try {
                String botJson = Files.readString(Path.of(this.getClass().getClassLoader().getResource("bot.json").toURI()));
                this.config = (BotConfiguration)new Gson().fromJson(botJson, BotConfiguration.class);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        this.logger = LoggerFactory.getLogger((String)this.getName());
        this.logger.info("Loading " + this.getName() + " v" + this.getVersion() + " by " + this.getDevelopersAsString());
        JDABuilder jdaBuilder = JDABuilder.createLight((String)(state == State.PRODUCTION ? this.config.getTokens().production : this.config.getTokens().debug));
        this.config.setTokens(null);
        this.onLogin(jdaBuilder);
        this.jda = jdaBuilder.build();
        this.commandManager = new CommandManager(this);
        if (state == State.DEBUG) {
            this.commandManager.setPrefix(">");
        }
        this.onEnable();
        this.commandManager.updateCommands();
    }

    protected BotConfiguration getConfig() {
        return this.config;
    }

    protected void setConfig(BotConfiguration config) {
        this.config = config;
    }

    public JDA getJda() {
        return this.jda;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static enum State {
        PRODUCTION,
        DEBUG;

    }
}

