/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api.command;

import com.siblaze.disbot.api.Abilities;
import com.siblaze.disbot.api.Ability;
import com.siblaze.disbot.api.command.CommandEvent;
import com.siblaze.disbot.api.command.CommandOption;
import com.siblaze.disbot.api.command.OptionValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import org.jetbrains.annotations.ApiStatus;

public abstract class Command {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int EVERYONE = 0;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int ADMINISTRATOR = 1;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int SERVER_OWNER = 2;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int NO_ONE = 3;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int DJ_OR_ALONE = 4;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int DJ_ONLY = 5;
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final int LAX = 6;
    private final String name;
    private final Ability ability;
    private int context;
    private final String[] aliases;
    private final String description;
    private final List<CommandOption> options = new ArrayList<CommandOption>();
    private String anonymousField;

    public Command(String name, Ability ability, int context, String description, String ... aliases) {
        this.name = name;
        this.ability = ability;
        this.context = context;
        this.description = description;
        this.aliases = aliases;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public Command(String name, int defaultPermissionLevel, String description, String ... aliases) {
        this(name, switch (defaultPermissionLevel) {
            case 1 -> Abilities.ADMINISTRATOR;
            case 2 -> Abilities.SERVER_OWNER;
            case 3 -> Abilities.NO_ONE;
            case 4 -> Abilities.DJ_OR_ALONE;
            case 5 -> Abilities.DJ_ONLY;
            case 6 -> Abilities.DEVELOPER;
            default -> Abilities.EVERYONE;
        }, 15, description, aliases);
    }

    public Command(String name, String description, String ... aliases) {
        this(name, Abilities.EVERYONE, 15, description, aliases);
    }

    public void registerOption(CommandOption option) {
        this.options.add(option);
    }

    public void registerOption(OptionData option) {
        this.options.add(new CommandOption(option));
    }

    public void registerOption(OptionType type, String field, String description, boolean isRequired) {
        this.options.add(new CommandOption(type, field, description, isRequired));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public void registerOption(OptionType type, String field, String description, boolean isRequired, int permission) {
        this.options.add(new CommandOption(type, field, description, isRequired, switch (permission) {
            case 1 -> Abilities.ADMINISTRATOR;
            case 2 -> Abilities.SERVER_OWNER;
            case 3 -> Abilities.NO_ONE;
            case 4 -> Abilities.DJ_OR_ALONE;
            case 5 -> Abilities.DJ_ONLY;
            case 6 -> Abilities.DEVELOPER;
            default -> Abilities.EVERYONE;
        }));
    }

    public void registerOption(OptionType type, String field, String description, boolean isRequired, Ability ability) {
        this.options.add(new CommandOption(type, field, description, isRequired, ability));
    }

    public CommandOption getOption(String name) {
        for (CommandOption option : this.options) {
            if (!option.getName().equalsIgnoreCase(name)) continue;
            return option;
        }
        return null;
    }

    public DefaultMemberPermissions getDefaultSlashPermission() {
        return this.ability.getSlashCommandPermission();
    }

    public boolean matches(String command) {
        if (this.name.equalsIgnoreCase(command)) {
            return true;
        }
        if (this.aliases != null) {
            for (String alias : this.aliases) {
                if (!alias.equalsIgnoreCase(command)) continue;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public boolean hasPermission(Member member, int permission) {
        return true;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public boolean hasPermission(Member member) {
        return true;
    }

    public void missingOption(CommandOption option, MessageChannel channel) {
        this.missingOption(option.getOptionData(), channel);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public void missingOption(OptionData option, MessageChannel channel) {
        EmbedBuilder eb = new EmbedBuilder();
        eb.setTitle("Missing Option: " + option.getName());
        eb.setColor(Color.RED);
        eb.addField("", option.getName() + " is a required field", true);
        channel.sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public int getDefaultPermissionLevel() {
        return -1;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Command)) {
            return false;
        }
        Command c = (Command)other;
        return this.getName().equalsIgnoreCase(c.getName());
    }

    public abstract void onCommand(CommandEvent var1, Map<String, OptionValue> var2);

    public String getName() {
        return this.name;
    }

    public Ability getAbility() {
        return this.ability;
    }

    public int getContext() {
        return this.context;
    }

    void setContext(int context) {
        this.context = context;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public List<CommandOption> getOptions() {
        return this.options;
    }

    public String getAnonymousField() {
        return this.anonymousField;
    }

    public void setAnonymousField(String anonymousField) {
        this.anonymousField = anonymousField;
    }
}

