/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api;

import com.siblaze.disbot.api.Ability;
import com.siblaze.disbot.api.Developer;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Role;
import org.jetbrains.annotations.ApiStatus;

public final class Abilities {
    public static final Ability EVERYONE = Ability.of((bot, member) -> true);
    public static final Ability ADMINISTRATOR = Ability.of(Permission.ADMINISTRATOR);
    public static final Ability SERVER_OWNER = Ability.of((bot, member) -> member.isOwner(), Permission.ADMINISTRATOR);
    public static final Ability NO_ONE = Ability.of((bot, member) -> false);
    public static final Ability DEVELOPER = Ability.of((bot, member) -> {
        for (Developer dev : bot.getDevelopers()) {
            if (dev.getId() != member.getIdLong()) continue;
            return true;
        }
        return false;
    });
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final Ability DJ_OR_ALONE = Ability.of((bot, member) -> {
        if (member.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || member.hasPermission(new Permission[]{Permission.MANAGE_CHANNEL})) {
            return true;
        }
        if (member.getVoiceState().getChannel() != null && member.getVoiceState().getChannel().getMembers().size() <= 2) {
            return true;
        }
        for (Role role : member.getRoles()) {
            if (!role.getName().equalsIgnoreCase("DJ")) continue;
            return true;
        }
        return false;
    });
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="1.4")
    public static final Ability DJ_ONLY = Ability.of((bot, member) -> {
        if (member.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || member.hasPermission(new Permission[]{Permission.MANAGE_CHANNEL})) {
            return true;
        }
        for (Role role : member.getRoles()) {
            if (!role.getName().equalsIgnoreCase("DJ")) continue;
            return true;
        }
        return false;
    });
}

