/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot;

import com.google.gson.Gson;
import com.siblaze.disbot.DisBotConfiguration;
import com.siblaze.disbot.api.BotConfiguration;
import com.siblaze.disbot.api.DiscordBot;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class App {
    private static DisBotConfiguration config;
    private static final List<DiscordBot> bots;
    private static final Logger logger;

    public static void main(String[] args) {
        File[] bots;
        logger.info("Starting DisBot v1.3");
        File configFile = new File("config.json");
        if (!configFile.exists()) {
            InputStream defaultConfig = App.class.getResourceAsStream("/config.json");
            try {
                Files.copy(defaultConfig, configFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        try {
            String json = Files.readString(configFile.toPath());
            config = (DisBotConfiguration)new Gson().fromJson(json, DisBotConfiguration.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        File botsFolder = new File(App.config.botsFolder);
        if (!botsFolder.exists()) {
            botsFolder.mkdir();
        }
        for (File botJar : bots = botsFolder.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"))) {
            try {
                URLClassLoader loader = new URLClassLoader(new URL[]{botJar.toURI().toURL()}, ClassLoader.getSystemClassLoader());
                URI uri = loader.getResource("bot.json").toURI();
                HashMap env = new HashMap();
                String[] array = uri.toString().split("!");
                FileSystem fs = FileSystems.newFileSystem(URI.create(array[0]), env);
                String botJson = Files.readString(fs.getPath(array[1], new String[0]));
                BotConfiguration botConfig = (BotConfiguration)new Gson().fromJson(botJson, BotConfiguration.class);
                Object obj = Class.forName(botConfig.getMainClass(), true, loader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (obj instanceof DiscordBot) {
                    DiscordBot bot = (DiscordBot)obj;
                    bot.load(DiscordBot.State.PRODUCTION);
                    continue;
                }
                logger.error("Main class does not extend from DiscordBot");
            }
            catch (IOException | URISyntaxException e) {
                logger.error("Could not load bot from " + botJar.getName() + ". Make sure bot.json is present!", (Throwable)e);
            }
            catch (Exception e) {
                logger.error("Could not load bot from " + botJar.getName() + ".", (Throwable)e);
            }
        }
        try {
            Scanner scanner = new Scanner(System.in);
            try {
                while (true) {
                    String line;
                    if (!(line = scanner.nextLine()).equalsIgnoreCase("end")) {
                        continue;
                    }
                    logger.info("Shutting down...");
                    System.exit(0);
                }
            }
            catch (Throwable throwable) {
                try {
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static DisBotConfiguration getConfig() {
        return config;
    }

    static {
        bots = new ArrayList<DiscordBot>();
        logger = LoggerFactory.getLogger((String)"DisBot");
    }
}

