/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api.command;

import com.google.common.base.Joiner;
import com.siblaze.disbot.api.command.Command;
import com.siblaze.disbot.api.command.CommandEvent;
import com.siblaze.disbot.api.command.OptionValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import org.jetbrains.annotations.NotNull;

public class CommandManager
extends ListenerAdapter {
    private final List<Command> commandsGuild = new ArrayList<Command>();
    private final List<Command> commandsDm = new ArrayList<Command>();
    private final List<Command> commandsGuildSlash = new ArrayList<Command>();
    private final List<Command> commandsDmSlash = new ArrayList<Command>();
    private final JDA jda;
    private String prefix = "!";

    public CommandManager(JDA jda) {
        this.jda = jda;
        jda.addEventListener(new Object[]{this});
        jda.updateCommands().queue();
    }

    public Command[] getCommands(int contexts) {
        ArrayList<Command> commands = new ArrayList<Command>();
        if ((contexts & 1) == 1) {
            for (Command command : this.commandsGuild) {
                if (commands.contains(command)) continue;
                commands.add(command);
            }
        }
        if ((contexts & 2) == 2) {
            for (Command command : this.commandsDm) {
                if (commands.contains(command)) continue;
                commands.add(command);
            }
        }
        if ((contexts & 4) == 4) {
            for (Command command : this.commandsGuildSlash) {
                if (commands.contains(command)) continue;
                commands.add(command);
            }
        }
        if ((contexts & 8) == 8) {
            for (Command command : this.commandsGuild) {
                if (commands.contains(command)) continue;
                commands.add(command);
            }
        }
        return commands.toArray(new Command[0]);
    }

    public void registerCommand(Command command, int contexts) {
        if ((contexts & 1) == 1) {
            this.commandsGuild.add(command);
        }
        if ((contexts & 2) == 2) {
            this.commandsDm.add(command);
        }
        if ((contexts & 4) == 4) {
            this.commandsGuildSlash.add(command);
            this.jda.upsertCommand(command.getName(), command.getDescription()).addOptions(command.getOptions()).setDefaultPermissions(command.getDefaultSlashPermission()).queue();
        }
        if ((contexts & 8) == 8) {
            this.commandsDmSlash.add(command);
            this.jda.upsertCommand(command.getName(), command.getDescription()).addOptions(command.getOptions()).setDefaultPermissions(command.getDefaultSlashPermission()).queue();
        }
    }

    public Command getCommand(String label, boolean dm) {
        List<Command> commands = dm ? this.commandsDm : this.commandsGuild;
        for (Command cmd : commands) {
            if (!cmd.matches(label)) continue;
            return cmd;
        }
        return null;
    }

    public Command getCommand(String label) {
        return this.getCommand(label, false);
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        try {
            String msg = event.getMessage().getContentRaw();
            if (msg.startsWith(this.prefix)) {
                String command = msg.split(" ")[0].substring(this.prefix.length());
                List<Command> commands = event.isFromGuild() || event.isFromThread() ? this.commandsGuild : this.commandsDm;
                for (Command cmd : commands) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.hasPermission(event.getMember())) {
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        ArrayList<String> anonymousOptions = new ArrayList<String>();
                        ArrayList<String> unrecognizedOptions = new ArrayList<String>();
                        if (msg.contains(" ")) {
                            String[] split = msg.split(" ", 2)[1].split(" ");
                            for (String s : split) {
                                if (s.startsWith("-")) {
                                    String name;
                                    if (s.contains("=")) {
                                        name = s.split("=")[0].substring(1);
                                        String value = s.split("=")[1];
                                        boolean optionExists = false;
                                        for (OptionData option : cmd.getOptions()) {
                                            if (!option.getName().equalsIgnoreCase(name) || !cmd.hasPermission(event.getMember(), cmd.getOptionPermissions().get(option.getName()))) continue;
                                            options.put(option.getName(), new OptionValue(option.getType(), option.getName(), value));
                                            optionExists = true;
                                            break;
                                        }
                                        if (optionExists) continue;
                                        unrecognizedOptions.add(name);
                                        continue;
                                    }
                                    name = s.substring(1);
                                    boolean optionExists = false;
                                    for (OptionData option : cmd.getOptions()) {
                                        if (!option.getName().equalsIgnoreCase(name) || !cmd.hasPermission(event.getMember(), cmd.getOptionPermissions().get(option.getName()))) continue;
                                        options.put(option.getName(), new OptionValue(option.getType(), option.getName(), "true"));
                                        optionExists = true;
                                        break;
                                    }
                                    if (optionExists) continue;
                                    unrecognizedOptions.add(name);
                                    continue;
                                }
                                anonymousOptions.add(s);
                            }
                        }
                        if (cmd.getAnonymousField() != null && anonymousOptions.size() > 0) {
                            String anonymousString = Joiner.on((char)' ').join(anonymousOptions);
                            options.putIfAbsent(cmd.getAnonymousField(), new OptionValue(OptionType.STRING, cmd.getAnonymousField(), anonymousString));
                        } else {
                            int index = 0;
                            for (OptionData option : cmd.getOptions()) {
                                if (index >= anonymousOptions.size()) break;
                                if (options.containsKey(option.getName()) || !cmd.hasPermission(event.getMember(), cmd.getOptionPermissions().get(option.getName()))) continue;
                                options.put(option.getName(), new OptionValue(option.getType(), option.getName(), (String)anonymousOptions.get(index++)));
                            }
                        }
                        for (OptionData option : cmd.getOptions()) {
                            if (options.containsKey(option.getName()) || !option.isRequired()) continue;
                            cmd.missingOption(option, (MessageChannel)event.getChannel());
                            return;
                        }
                        if (unrecognizedOptions.size() > 0) {
                            EmbedBuilder eb = new EmbedBuilder();
                            eb.setTitle("Unknown Options Provided");
                            eb.setColor(Color.RED);
                            for (String option : unrecognizedOptions) {
                                eb.addField("", option, true);
                            }
                            eb.addField("", "Tip: Using slash commands will show you all valid options", false);
                            event.getChannel().sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getAuthor()).setMember(event.getMember()).setChannel(event.getChannel()).setMessage(event.getMessage()).setGuild(event.getGuild());
                        cmd.onCommand(ce, options);
                    } else {
                        event.getChannel().sendMessage((CharSequence)"Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EmbedBuilder eb = new EmbedBuilder();
            eb.setTitle("An error occurred");
            eb.setColor(Color.RED);
            eb.addField("", e.getLocalizedMessage(), true);
            event.getChannel().sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
        }
    }

    public void onSlashCommandInteraction(@NotNull SlashCommandInteractionEvent event) {
        try {
            String command = event.getName();
            if (event.getGuild() != null) {
                for (Command cmd : this.commandsGuildSlash) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.hasPermission(event.getMember())) {
                        List optionMap = event.getOptions();
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        for (OptionMapping map : optionMap) {
                            options.put(map.getName(), new OptionValue(map.getType(), map.getName(), map.getAsString()));
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getUser()).setMember(event.getMember()).setChannel(event.getChannel()).setSlashCommand(true).setSlashCommandEvent(event).setGuild(event.getGuild());
                        cmd.onCommand(ce, options);
                    } else {
                        event.reply("Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
            } else {
                for (Command cmd : this.commandsDmSlash) {
                    if (!cmd.matches(command)) continue;
                    if (cmd.hasPermission(event.getMember())) {
                        List optionMap = event.getOptions();
                        HashMap<String, OptionValue> options = new HashMap<String, OptionValue>();
                        for (OptionMapping map : optionMap) {
                            options.put(map.getName(), new OptionValue(map.getType(), map.getName(), map.getAsString()));
                        }
                        CommandEvent ce = new CommandEvent(command, this).setUser(event.getUser()).setMember(event.getMember()).setChannel(event.getChannel()).setSlashCommand(true).setSlashCommandEvent(event);
                        cmd.onCommand(ce, options);
                    } else {
                        event.reply("Sorry, you don't have permission to use that command!").queue();
                    }
                    return;
                }
                event.reply("Sorry, this command is only available on servers").queue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            EmbedBuilder eb = new EmbedBuilder();
            eb.setTitle("An error occurred");
            eb.setColor(Color.RED);
            eb.addField("", e.getLocalizedMessage(), true);
            event.replyEmbeds(eb.build(), new MessageEmbed[0]).queue();
        }
    }

    public JDA getJda() {
        return this.jda;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

