/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api.command;

import com.siblaze.disbot.api.command.CommandEvent;
import com.siblaze.disbot.api.command.OptionValue;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;

public abstract class Command {
    public static int EVERYONE = 0;
    public static int ADMINISTRATOR = 1;
    public static int SERVER_OWNER = 2;
    public static int NO_ONE = 3;
    public static int DJ_OR_ALONE = 4;
    public static int DJ_ONLY = 5;
    public static int LAX = 6;
    private final String name;
    private final int defaultPermissionLevel;
    private final String[] aliases;
    private final String description;
    private final List<OptionData> options = new ArrayList<OptionData>();
    private final HashMap<String, Integer> optionPermissions = new HashMap();
    private String anonymousField;

    public Command(String name, int defaultPermissionLevel, String description, String ... aliases) {
        this.name = name;
        this.defaultPermissionLevel = defaultPermissionLevel;
        this.description = description;
        this.aliases = aliases;
    }

    public Command(String name, String description, String ... aliases) {
        this(name, EVERYONE, description, aliases);
    }

    public void registerOption(OptionData option) {
        this.options.add(option);
        this.optionPermissions.put(option.getName(), EVERYONE);
    }

    public void registerOption(OptionType type, String field, String description, boolean isRequired) {
        this.options.add(new OptionData(type, field, description, isRequired));
        this.optionPermissions.put(field, EVERYONE);
    }

    public void registerOption(OptionType type, String field, String description, boolean isRequired, int permission) {
        this.options.add(new OptionData(type, field, description, isRequired));
        this.optionPermissions.put(field, permission);
    }

    public DefaultMemberPermissions getDefaultSlashPermission() {
        if (this.defaultPermissionLevel == EVERYONE) {
            return DefaultMemberPermissions.ENABLED;
        }
        if (this.defaultPermissionLevel == ADMINISTRATOR) {
            return DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR});
        }
        if (this.defaultPermissionLevel == SERVER_OWNER) {
            return DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.ADMINISTRATOR});
        }
        if (this.defaultPermissionLevel == DJ_OR_ALONE) {
            return DefaultMemberPermissions.ENABLED;
        }
        if (this.defaultPermissionLevel == DJ_ONLY) {
            return DefaultMemberPermissions.ENABLED;
        }
        if (this.defaultPermissionLevel == LAX) {
            return DefaultMemberPermissions.DISABLED;
        }
        return DefaultMemberPermissions.DISABLED;
    }

    public boolean matches(String command) {
        if (this.name.equalsIgnoreCase(command)) {
            return true;
        }
        if (this.aliases != null) {
            for (String alias : this.aliases) {
                if (!alias.equalsIgnoreCase(command)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(Member member, int permission) {
        if (permission == EVERYONE) {
            return true;
        }
        if (permission == ADMINISTRATOR) {
            return member.hasPermission(new Permission[]{Permission.ADMINISTRATOR});
        }
        if (permission == SERVER_OWNER) {
            return member.isOwner();
        }
        if (permission == DJ_OR_ALONE) {
            if (member.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || member.hasPermission(new Permission[]{Permission.MANAGE_CHANNEL})) {
                return true;
            }
            if (member.getVoiceState().getChannel() != null && member.getVoiceState().getChannel().getMembers().size() <= 2) {
                return true;
            }
            for (Role role : member.getRoles()) {
                if (!role.getName().equalsIgnoreCase("DJ")) continue;
                return true;
            }
            return false;
        }
        if (permission == DJ_ONLY) {
            if (member.hasPermission(new Permission[]{Permission.ADMINISTRATOR}) || member.hasPermission(new Permission[]{Permission.MANAGE_CHANNEL})) {
                return true;
            }
            for (Role role : member.getRoles()) {
                if (!role.getName().equalsIgnoreCase("DJ")) continue;
                return true;
            }
            return false;
        }
        if (permission == LAX) {
            return member.getIdLong() == 573609645172719617L;
        }
        return false;
    }

    public boolean hasPermission(Member member) {
        return this.hasPermission(member, this.defaultPermissionLevel);
    }

    public void missingOption(OptionData option, MessageChannel channel) {
        EmbedBuilder eb = new EmbedBuilder();
        eb.setTitle("Missing Option: " + option.getName());
        eb.setColor(Color.RED);
        eb.addField("", option.getName() + " is a required field", true);
        channel.sendMessageEmbeds(eb.build(), new MessageEmbed[0]).queue();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Command)) {
            return false;
        }
        Command c = (Command)other;
        return this.getName().equalsIgnoreCase(c.getName());
    }

    public abstract void onCommand(CommandEvent var1, Map<String, OptionValue> var2);

    public String getName() {
        return this.name;
    }

    public int getDefaultPermissionLevel() {
        return this.defaultPermissionLevel;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public List<OptionData> getOptions() {
        return this.options;
    }

    public HashMap<String, Integer> getOptionPermissions() {
        return this.optionPermissions;
    }

    public String getAnonymousField() {
        return this.anonymousField;
    }

    public void setAnonymousField(String anonymousField) {
        this.anonymousField = anonymousField;
    }
}

