/*
 * Decompiled with CFR 0.152.
 */
package com.siblaze.disbot.api;

import com.google.gson.Gson;
import com.siblaze.disbot.api.BotConfiguration;
import com.siblaze.disbot.api.command.CommandManager;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;

public abstract class DiscordBot {
    private BotConfiguration config;
    private JDA jda;
    private CommandManager commandManager;

    public void onLogin(JDABuilder jdaBuilder) {
    }

    public void onEnable() {
    }

    public void load(State state) {
        if (this.getConfig() == null) {
            try {
                String botJson = Files.readString(Path.of(this.getClass().getClassLoader().getResource("bot.json").toURI()));
                this.config = (BotConfiguration)new Gson().fromJson(botJson, BotConfiguration.class);
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        JDABuilder jdaBuilder = JDABuilder.createLight((String)(state == State.PRODUCTION ? this.config.tokens.production : this.config.tokens.debug));
        this.onLogin(jdaBuilder);
        this.jda = jdaBuilder.build();
        this.commandManager = new CommandManager(this.jda);
        if (state == State.DEBUG) {
            this.commandManager.setPrefix(">");
        }
        this.onEnable();
    }

    public BotConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(BotConfiguration config) {
        this.config = config;
    }

    public JDA getJda() {
        return this.jda;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public static enum State {
        PRODUCTION,
        DEBUG;

    }
}

